//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------
$AudioChannel1 = 1;
$AudioChannel2 = 2;
$AudioChannel3 = 3;
$AudioChannel4 = 4;
//-----------------------------------------------------------------------------
// 2d sounds
//-----------------------------------------------------------------------------

// Used for non-looping environmental sounds (like power on, power off)
datablock AudioDescription(Audio2D) //Sound effects and Vocals
{
   volume = 1.0;
   isLooping = false;
   is3D = false;
   type = $AudioChannel3;
};

// Used for Looping Sound FX
datablock AudioDescription(FXLooping2D)
{
   volume = 1.0;
   isLooping = true;
   is3D = false;
   type = $AudioChannel4;
};

// Used for Looping Environmental Sounds
datablock AudioDescription(AudioLooping2D)   //Ambience
{
   volume = 1.0;
   isLooping = true;
   is3D = false;
   type = $AudioChannel4;
};

// Used for Looping Music
datablock AudioDescription(MusicLooping)
{
   volume = 1.0;
   isLooping = true;
   is3D = false;
   type = $AudioChannel1;
};

//MUSIC/////////////////////////////////////////////////////////////////////////
datablock AudioProfile(MusicMainMenu)
{
   filename = "~/data/sound/music/music_mainmenu.ogg";
   description = "MusicLooping";
	preload = false;
};

datablock AudioProfile(MusicInGame0)
{
   filename = "~/data/sound/music/music_ingame0.ogg";
   description = "MusicLooping";
	preload =  false;
};

datablock AudioProfile(MusicInGame1)
{
   filename = "~/data/sound/music/music_ingame1.ogg";
   description = "MusicLooping";
	preload =  false;
};

datablock AudioProfile(MusicInGame2)
{
   filename = "~/data/sound/music/music_ingame2.ogg";
   description = "MusicLooping";
	preload =  false;
};

datablock AudioProfile(MusicCombat)
{
   filename = "~/data/sound/music/music_combat.ogg";
   description = "MusicLooping";
	preload =  false;
};

/*datablock AudioProfile(MusicCredits)
{
   filename = "~/data/sound/music/music_credits.ogg";
   description = "MusicLooping";
	preload = true;
};*/

//MUSIC/////////////////////////////////////////////////////////////////////////
datablock AudioProfile(amb_nature)
{
   filename = "~/data/sound/ambience/nature_amb_loop.ogg";
   description = "AudioLooping2D";
	preload = false;
};
datablock AudioProfile(audio_drought)
{
   filename = "~/data/sound/ambience/drought_amb.ogg";
   description = "Audio2D";
	preload = false;
};
datablock AudioProfile(audio_fire)
{
   filename = "~/data/sound/ambience/fire_amb.ogg";
   description = "Audio2D";
	preload = false;
};
datablock AudioProfile(audio_tornado)
{
   filename = "~/data/sound/ambience/twister_amb.ogg";
   description = "Audio2D";
	preload = false;
};
datablock AudioProfile(audio_quake)
{
   filename = "~/data/sound/ambience/quake_amb.ogg";
   description = "Audio2D";
	preload = false;
};
datablock AudioProfile(audio_famine)
{
   filename = "~/data/sound/ambience/famine_amb.ogg";
   description = "Audio2D";
	preload = false;
};
datablock AudioProfile(audio_plague)
{
   filename = "~/data/sound/ambience/plague_amb.ogg";
   description = "Audio2D";
	preload = false;
};
datablock AudioProfile(audio_hunger)
{
   filename = "~/data/sound/ambience/hunger_amb.ogg";
   description = "Audio2D";
	preload = false;
};
datablock AudioProfile(audio_parade)
{
   filename = "~/data/sound/ambience/amb_parade.ogg";
   description = "Audio2D";
	preload = false;
};

//PICK UPS////////////////////////////////////////////////////////////////////
datablock AudioProfile(pickup_wood)
{
	filename = "~/data/sound/misc/pickupwood.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(pickup_food)
{
	filename = "~/data/sound/misc/pickupfood.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(pickup_gold)
{
	filename = "~/data/sound/misc/pickupgold.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(pickup_generic)
{
	filename = "~/data/sound/misc/pickup.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(quickjob_wood)
{
   filename = "~/data/sound/misc/work_chop0.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(quickjob_food)
{
   filename = "~/data/sound/misc/work_fish0.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(quickjob_gold)
{
   filename = "~/data/sound/misc/work_pick0.ogg";
	description = "Audio2D";
	preload="false";
};

//MISC//////////////////////////////////////////////////////////////////////
datablock AudioProfile(audio_itembuy)
{
   filename = "~/data/sound/misc/item_buy.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_itemsell)
{
   filename = "~/data/sound/misc/item_sell.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_dynamiteexplode)
{
   filename = "~/data/sound/misc/tool_dynamite_explode.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_dynamitesizzle)
{
   filename = "~/data/sound/misc/tool_dynamite_sizzle.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_usehealthpack)
{
   filename = "~/data/sound/misc/tool_health_use.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_treefall)
{
   filename = "~/data/sound/misc/tree_fall0.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_awardbadge)
{
   filename = "~/data/sound/misc/award_badge.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_awardxp)
{
   filename = "~/data/sound/misc/award_xp.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_questavailable)
{
   filename = "~/data/sound/misc/quest_available.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_questcomplete)
{
   filename = "~/data/sound/misc/quest_complete.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_trainstart)
{
   filename = "~/data/sound/misc/train_start.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_trainstop)
{
   filename = "~/data/sound/misc/train_stop.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_trainsoundoff)
{
   filename = "~/data/sound/misc/train_soundoff.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_trainrolling)
{
   filename = "~/data/sound/misc/train_rolling.ogg";
	description = "FXLooping2D";
	preload="false";
};
datablock AudioProfile(audio_wagonstart)
{
   filename = "~/data/sound/misc/wagon_start.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_wagonstop)
{
   filename = "~/data/sound/misc/wagon_stop.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_wagonsoundoff)
{
   filename = "~/data/sound/misc/wagon_soundoff.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_wagonrolling)
{
   filename = "~/data/sound/misc/wagon_rolling.ogg";
	description = "FXLooping2D";
	preload="false";
};
datablock AudioProfile(audio_arrestdrunk)
{
   filename = "~/data/sound/misc/arrested.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(audio_gotdrunk)
{
   filename = "~/data/sound/misc/gotdrunk.ogg";
	description = "Audio2D";
	preload="false";
};

//COMBAT////////////////////////////////////////////////////////////////////
datablock AudioProfile(gun_rifle0)
{
	filename = "~/data/sound/misc/gun_rifle0.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(gun_revolver0)
{
	filename = "~/data/sound/misc/gun_revolver0.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(gun_musket0)
{
	filename = "~/data/sound/misc/gun_musket0.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(gun_shotgun0)
{
	filename = "~/data/sound/misc/gun_shotgun0.ogg";
	description = "Audio2D";
	preload="false";
};

datablock AudioProfile(gun_ricochet1)
{
	filename = "~/data/sound/misc/gun_ricochet1.ogg";
	description = "Audio2D";
	preload="false";
};

datablock AudioProfile(combat_start)
{
	filename = "~/data/sound/misc/combat_start.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(combat_defeat)
{
	filename = "~/data/sound/misc/combat_defeat.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(combat_victory)
{
	filename = "~/data/sound/misc/combat_victory.ogg";
	description = "Audio2D";
	preload="false";
};

//BUILDINGS////////////////////////////////////////////////////////////////////
datablock AudioProfile(bank_SEL)
{
	filename = "~/data/sound/buildings/bank_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(barbershop_SEL)
{
	filename = "~/data/sound/buildings/barbershop_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(blacksmith_SEL)
{
	filename = "~/data/sound/buildings/blacksmith_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(church_SEL)
{
	filename = "~/data/sound/buildings/church_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(farm_SEL)
{
	filename = "~/data/sound/buildings/farm_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(gazebo_SEL)
{
	filename = "~/data/sound/buildings/gazebo_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(generalstore_SEL)
{
	filename = "~/data/sound/buildings/generalstore_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(goldmine_SEL)
{
	filename = "~/data/sound/buildings/goldmine_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(granary_SEL)
{
	filename = "~/data/sound/buildings/granary_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(hotel_SEL)
{
	filename = "~/data/sound/buildings/hotel_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(logcabin_SEL)
{
	filename = "~/data/sound/buildings/logcabin_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(lumbermill_SEL)
{
	filename = "~/data/sound/buildings/lumbermill_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(outhouse_SEL)
{
	filename = "~/data/sound/buildings/outhouse_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(platform_SEL)
{
	filename = "~/data/sound/buildings/platform_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(outpost_SEL)
{
	filename = "~/data/sound/buildings/outpost_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(ranch_SEL)
{
	filename = "~/data/sound/buildings/ranch_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(saloon_SEL)
{
	filename = "~/data/sound/buildings/saloon_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(shack_SEL)
{
	filename = "~/data/sound/buildings/shack_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(sheriffsoffice_SEL)
{
	filename = "~/data/sound/buildings/sheriffsoffice_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(smokehouse_SEL)
{
	filename = "~/data/sound/buildings/smokehouse_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(townhall_SEL)
{
	filename = "~/data/sound/buildings/townhall_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(tradingpost_SEL)
{
	filename = "~/data/sound/buildings/tradingpost_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(trainstation_SEL)
{
	filename = "~/data/sound/buildings/trainstation_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(watchtower_SEL)
{
	filename = "~/data/sound/buildings/watchtower_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(watertower_SEL)
{
	filename = "~/data/sound/buildings/watertower_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(well_SEL)
{
	filename = "~/data/sound/buildings/well_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(windmill_SEL)
{
	filename = "~/data/sound/buildings/windmill_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(woodhut_SEL)
{
	filename = "~/data/sound/buildings/woodhut_SEL.ogg";
	description = "Audio2D";
	preload="false";
};
datablock AudioProfile(building_construction)
{
	filename = "~/data/sound/buildings/building_construction.ogg";
	description = "FXLooping2D";
	preload="false";
};
datablock AudioProfile(building_destruction)
{
	filename = "~/data/sound/buildings/building_destruction.ogg";
	description = "Audio2D";
	preload="false";
};

function svrPlaySFXSound(%sound, %client)
{
   if(%client !$= "") {
      commandToClient(%client, 'PlaySFXSound', %sound);
   }
   else {
      %count = ClientGroup.getCount();
      for(%i = 0; %i < %count; %i++) {
         %client = ClientGroup.getObject(%i);
         commandToClient(%client, 'PlaySFXSound', %sound);
      }
   }
}